#include "missionloop.h"
#include "gameloop.h"
#include "NFont.h"

using namespace PL;
using namespace std;


extern NFont blackFont;

	

void showMission(GameState* gs, Level& level)
{
	MissionState state;
	state.screen = gs->screen;
	state.text = level.missionText;
	
	MissionUpdate update;
	
	MissionDraw draw;
	
	MissionEvent event;
	
	PL_Set set;
	set.update = &update;
	set.draw = &draw;
	set.any = &event;
	
	PL_Loop(&state, set);
	gs->dt = 0;
}

void MissionUpdate::update(PL_State* state)
{
    MissionState* s = static_cast<MissionState*>(state);
	
    if(s->startDelay >= 0)
        s->startDelay -= s->dt;
	
}

void MissionDraw::draw(PL_State* state)
{
    MissionState* s = static_cast<MissionState*>(state);
	
	SPG_RectRoundFilled(s->screen, 100, 100, 700, 500, 10, RGB_ORANGE);
	
    blackFont.drawCenter(400, 200, "%s", s->text);
    
    if(s->startDelay < 0)
        blackFont.drawCenter(400, 400, "Click to begin");
	
	SDL_Flip(s->screen);
}

bool MissionEvent::handleEvent(PL_State* state, SDL_Event& event)
{
    MissionState* s = static_cast<MissionState*>(state);
    
    if(event.type == SDL_MOUSEBUTTONDOWN)
    {
        if(event.button.button == SDL_BUTTON_LEFT)
        {
            if(s->startDelay < 0)
                s->done = true;
        }
    }
    
    return true;
}





